<?php
/**
 * Template Name:  archive
 * archive 
 */

get_header();
?>
  <?php get_template_part('partials/content', 'hero');?>
<section>
  <div class="container">
    <div class="row">
      <div class="col-12">
        <img src="<?php echo get_template_directory_uri()?>/img/pink-decoration.png" alt=""
          class="d-block mx-auto info__pic">
        <h2 class="news__title basic-title">
          Nasze wpisy
        </h2>
      </div>
    </div>
    <div class="row">
      <?php
            $query_args = array(
            'post_type' => array('post'),
            'posts_per_page' => '6',
            );
            $query = new WP_Query( $query_args );
            if ($query->have_posts()): while ($query->have_posts()) : $query->the_post();
            $the_ID = get_the_ID();
            $name = get_the_title();
            $pic = get_the_post_thumbnail_url( $the_ID , array( 540, 220) );
            $short_text = get_field('short-text', $the_ID);
            $link = get_permalink();
            ?>
      <div class="col-12 col-md-6">
        <div class="news-single">
          <img src="<?php echo $pic?>" alt="<?php echo $name?>" class="news-single__image">
          <h3 class="news-single__title">
            <?php echo $name?>

          </h3>
          <p class="news-single__text">
            <?php echo $short_text ?>
          </p>

          <a href="<?php echo $link ?>" class="news-single__link">
            Czytaj więcej
          </a>
        </div>
      </div>
      <?php
              endwhile;
              endif;
              wp_reset_postdata()
              ?>
    </div>
  </div>
</section>


<?php
get_footer();