<?php
/**
 * Template Name: attractions
 * archive attraction
 */

get_header();
?>
<main>

  <?php
  $max_count = wp_count_posts('attraction')->publish;
  $counter = 0;
  $style = '';
  if ($max_count % 2 != 0) {
    $style= 'margin-big';
    };
  if (have_posts()): while (have_posts()) : the_post();
  $post_name = get_field('short_title');
  $post_pic = get_field('home_page_picture');
  $post_short_text = get_field('short_text');
  $post_link = get_permalink();
  $post_color = get_field('hero_bg_color');
  $featured = get_field('featured');
  $archive_bg = get_field('archive_photo_background');
  $archive_image = wp_get_attachment_image_url( get_field('archive_photo'), 'archive');
  $wave_color = get_field('archive_wave_color');
  $counter = $counter + 1;
  ?>
  <section class="attraction-archive relative">
    <?php if($counter == 1):?>
    <svg preserveAspectRatio="none" class="attraction-archive__bg" id="Layer_1" data-name="Layer 1"
      xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1920 1034.95">
      <path class="cls-1" class="attractio-arvhive__bg" fill="<?php echo $post_color?>"
        d="M1920,238.6h-.22l.22,603.75-.3,124.81s-89.9-72.22-398.11,23c-185.48,58.24-311.4-11.34-334.25-23s-183.69-80.2-431,35.92c-50.75,23.24-94.86,31.87-132.6,31.87C528,1035,473.07,979.45,454,966.16c-35.31-24.6-122.07-65.95-348.22,24C25.29,1014.63,7.64,976.06,0,973.14V0H1920Z" />
    </svg>
    <?php elseif ($counter == $max_count):?>

    <svg preserveAspectRatio="none" class="attraction-archive__bg" id="Layer_1" data-name="Layer 1"
      xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1919.94 987.12">
      <path class="cls-1" fill="<?php echo $post_color?>"
        d="M1919.94,709.85V893.43l-.23,93.69H0V38.18c7.63,2.92,25.29,41.49,105.76,17,22.41-8.91,43.45-16.52,63.2-23C348.6-26.72,422.16,9,454,31.19c.42.3.87.61,1.33,1C475.53,46.93,530.08,100,623.71,100c37.74,0,81.85-8.63,132.59-31.87a777.1,777.1,0,0,1,90.49-36c195.47-63.48,320.3-10.23,340.47,0l.08,0c22.84,11.62,148.77,81.2,334.25,23,29.6-9.14,57.18-16.73,82.87-23,238.31-58.11,313.1-1.62,315.19,0l0,0Z" />
      <polygon class="cls-2" points="1919.94 893.43 1919.94 987.12 1919.71 987.12 1919.94 893.43" />
    </svg>
    <?php else:?>
    <?php if ($counter % 2 == 0):?>
    <svg preserveAspectRatio="none" class="attraction-archive__bg" id="Layer_1" data-name="Layer 1"
      xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1920 1025.46">
      <path class="cls-1" fill="<?php echo $post_color?>"
        d="M1920,868.47l-.3,124.79h0c-.76.6-74.74,58.72-315.38,0-25.64-6.25-53.18-13.84-82.72-23-185.48-58.24-311.41,11.33-334.25,23h0c-20,10.17-144.92,63.6-340.65,0a778.71,778.71,0,0,1-90.37-35.93c-176.52-80.84-272.5,15.12-300.94,35.93-.48.36-.94.68-1.38,1-31.83,22.17-105.41,57.93-285.13-1q-29.58-9.69-63.09-23C25.29,945.78,7.63,984.36,0,987.28V38.18c7.63,2.92,25.29,41.49,105.76,17,22.41-8.91,43.45-16.52,63.2-23C348.6-26.72,422.16,9,454,31.19c.42.3.87.61,1.33,1C475.53,46.93,530.08,100,623.71,100c37.74,0,81.85-8.63,132.59-31.87a777.1,777.1,0,0,1,90.49-36c195.47-63.48,320.3-10.23,340.47,0l.08,0c22.84,11.62,148.77,81.2,334.25,23,29.6-9.14,57.18-16.73,82.87-23,238.31-58.11,313.1-1.62,315.19,0l0,0Z" />
    </svg>
    <?php else: ?>
    <svg preserveAspectRatio="none" class="attraction-archive__bg" id="Layer_1" data-name="Layer 1"
      xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1920 1096.76">
      <g id="Shape-2">
        <path id="Shape-3" class="cls-1" fill="<?php echo $post_color?>"
          d="M454,1028c-35.31-24.6-122.07-66-348.22,24C25.29,1076.45,7.64,1037.87,0,1035V61.81c7.64-2.92,25.29-41.49,105.76-17,226.15,89.9,312.91,48.55,348.22,24C480.6,50.26,576.81-50.33,756.31,31.87c247.34,116.13,408.19,47.55,431,35.93s148.77-81.2,334.25-23c308.21,95.17,398.11,23,398.11,23l.3,836.36-.3,124.81s-89.9-72.22-398.11,23c-185.48,58.24-311.4-11.33-334.25-23s-183.69-80.2-431,35.93c-50.75,23.23-94.86,31.86-132.6,31.86C528,1096.77,473.07,1041.26,454,1028Z" />
      </g>
    </svg>
    <?php endif?>
    <?php endif?>
    <img src="<?php echo get_template_directory_uri()?>/img/bg-shapes.png" alt="" class="attraction-archive__bg-image">
    <div class="container <?php if($counter == $max_count){echo $style;}?>">
      <div class="row">
        <div class="col-10 offset-1 offset-lg-0 col-lg-6">
          <div class="relative">
            <svg preserveAspectRatio="none" class="attraction-archive__image" version="1.1" id="Layer_1"
              xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
              viewBox="0 0 638 673.3" style="enable-background:new 0 0 638 673.3;" xml:space="preserve">
              <path fill="<?php if(empty($archive_bg)){ echo '#ffcf14';} else {echo $archive_bg;}?>" id="_81"
                class="st0"
                d="M370.4,673.3h-64.9c-2.3-0.4-4.6-0.7-6.9-0.9c-12.8-0.4-25.6-0.5-38.4-1c-28.5-1.1-55.3-8.8-79.2-24.4
	  c-20.4-13.3-40.1-28-59.5-42.8c-39.3-30.1-69.1-68-90.3-112.6C5.5,437.2-4.3,380.1,1.7,320.2c3.5-36.1,14.9-70.9,33.3-102.1
	  c12.8-21.8,29-41,45-60.4c27.2-32.9,57.7-62.1,94-84.9c41.4-26,86.4-40,135.1-42.5c20.4-1,40.5,1.9,60.1,7.7c4.6,1.4,8.8,4.5,13.4,5
	c21.4,2.3,42.5,5.9,62.9,12.8c48.3,16.2,88.4,45,122.8,81.9c26.1,28,42.7,61.1,52.7,97.9c9.8,36.1,11.9,73.1,12.8,110.2
	c0.6,23.8,0.6,47.6-0.1,71.4c-0.5,15.1-1.5,30.3-4.4,45.1c-11.5,57.4-40.1,105.2-83.1,144.5c-3.1,2.8-6.5,5.4-9.7,8.1l0.9,1.1
	c5.7-4.5,12.2-8.2,16.9-13.6c14-16.2,27.9-32.6,40.5-49.9c14.8-20.3,26.5-42.7,36.4-65.8c1.3-3,2.5-6.1,6.9-4.1v2
	c-1.8,6.2-3.5,12.5-5.4,18.7c-9.7,30.7-28,56.4-47.2,81.7c-20.2,26.7-45.7,45.7-77.7,55.8c-22.5,7.1-45,14.3-67.8,20.5
	c-14.7,4-29.9,6.5-44.9,9.2C386.9,671.9,378.6,672.4,370.4,673.3z M360.7,41.3c-53.5-8-103.6,3.7-152,25.7
	C258.3,52,308.8,42.7,360.7,41.3z M405.8,1.4c0.8,1.5,1.4,3.4,2.7,4.2c29,17.8,58.1,35.4,87.3,53c1.2,0.7,2.9,0.4,4.4,0.5
	c-0.5-1.4-0.6-3.1-1.6-4.1C474.3,30.4,446,12.2,412.9,1.5c-1.6-0.5-3.2-0.9-5.1-1.5C407.1,0.4,406.4,0.9,405.8,1.4L405.8,1.4z" />
            </svg>
            <svg class="attraction-archive__photo" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
              xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 638 673.3"
              style="enable-background:new 0 0 638 673.3;" xml:space="preserve">
              <defs>
                <pattern id="bgImage-<?php echo $counter?>" patternUnits="userSpaceOnUse" width="100%" height="100%">
                  <image href="<?php echo $archive_image; ?>" x="0" y="0" width="100%" height="100%"
                    preserveAspectRatio="xMinYMin slice" />
                </pattern>
              </defs>
              <path fill="url(#bgImage-<?php echo $counter?>)" id="_81" class="st0"
                d="M370.4,673.3h-64.9c-2.3-0.4-4.6-0.7-6.9-0.9c-12.8-0.4-25.6-0.5-38.4-1c-28.5-1.1-55.3-8.8-79.2-24.4
	c-20.4-13.3-40.1-28-59.5-42.8c-39.3-30.1-69.1-68-90.3-112.6C5.5,437.2-4.3,380.1,1.7,320.2c3.5-36.1,14.9-70.9,33.3-102.1
	c12.8-21.8,29-41,45-60.4c27.2-32.9,57.7-62.1,94-84.9c41.4-26,86.4-40,135.1-42.5c20.4-1,40.5,1.9,60.1,7.7c4.6,1.4,8.8,4.5,13.4,5
	c21.4,2.3,42.5,5.9,62.9,12.8c48.3,16.2,88.4,45,122.8,81.9c26.1,28,42.7,61.1,52.7,97.9c9.8,36.1,11.9,73.1,12.8,110.2
	c0.6,23.8,0.6,47.6-0.1,71.4c-0.5,15.1-1.5,30.3-4.4,45.1c-11.5,57.4-40.1,105.2-83.1,144.5c-3.1,2.8-6.5,5.4-9.7,8.1l0.9,1.1
	c5.7-4.5,12.2-8.2,16.9-13.6c14-16.2,27.9-32.6,40.5-49.9c14.8-20.3,26.5-42.7,36.4-65.8c1.3-3,2.5-6.1,6.9-4.1v2
	c-1.8,6.2-3.5,12.5-5.4,18.7c-9.7,30.7-28,56.4-47.2,81.7c-20.2,26.7-45.7,45.7-77.7,55.8c-22.5,7.1-45,14.3-67.8,20.5
	c-14.7,4-29.9,6.5-44.9,9.2C386.9,671.9,378.6,672.4,370.4,673.3z M360.7,41.3c-53.5-8-103.6,3.7-152,25.7
	C258.3,52,308.8,42.7,360.7,41.3z M405.8,1.4c0.8,1.5,1.4,3.4,2.7,4.2c29,17.8,58.1,35.4,87.3,53c1.2,0.7,2.9,0.4,4.4,0.5
	c-0.5-1.4-0.6-3.1-1.6-4.1C474.3,30.4,446,12.2,412.9,1.5c-1.6-0.5-3.2-0.9-5.1-1.5C407.1,0.4,406.4,0.9,405.8,1.4L405.8,1.4z" />
            </svg>
          </div>

        </div>
        <div class="col-12 offset-lg-1 col-lg-5">
          <svg class="single-attraction-text-section__pic" xmlns="http://www.w3.org/2000/svg" width="224.555"
            height="14.338" viewBox="0 0 224.555 14.338">
            <path id="Path_39" data-name="Path 39"
              d="M-51.743-208.481c12.473,0,12.473,11.338,24.945,11.338s12.473-11.338,24.947-11.338S10.623-197.143,23.1-197.143s12.475-11.338,24.95-11.338S60.523-197.143,73-197.143s12.476-11.338,24.951-11.338,12.476,11.338,24.952,11.338,12.478-11.338,24.955-11.338,12.478,11.338,24.956,11.338"
              transform="translate(51.743 209.981)" fill="none" stroke="<?php echo $wave_color ?>"
              stroke-miterlimit="10" stroke-width="3" />
          </svg>
          <h2 class="attraction-archive__title basic-title">
            <?php echo $post_name;?>
          </h2>
          <p class="attraction-archive__text">
            <?php echo  $post_short_text;?>
          </p>
          <a href="<?php  echo get_permalink();?>" class="attraction-archive__button"
            style="background-color:<?php echo $wave_color?>">
            <?php  echo get_field('archive_link_text');?> <img
              src="<?php echo get_template_directory_uri()?>/img/chevron.svg" alt="" class="attraction-archive__pic">
          </a>
        </div>
      </div>
    </div>


  </section>
  <?php endwhile; endif; wp_reset_postdata(); ?>

  <?php get_template_part('partials/content', 'contact');?>
  <?php get_template_part('partials/content', 'info');?>
</main>

<?php

get_footer();