<?php
/**
 * Template Name:  contact-page
 * contact-page
 */

get_header();
$hero_bg = get_field('hero-bg-image');

$text_color = get_field('hero_bg_color');
$bg_color = get_field('hero_bg_color');
?>
<style>
.hero__link {
  background-color: <?php echo $text_color?>;
  border-color: <?php echo $text_color?>
}

.hero__link:hover {
  background-color: #ffffff;
  color: <?php echo $text_color?>;
}

.hero__link:nth-child(2) {
  color: <?php echo $text_color?>;
  border-color: <?php echo $text_color?>
}

.hero__link:nth-child(2):hover {
  color: #ffffff;
  background-color: <?php echo $text_color?>;
}
</style>
<main>
  <?php get_template_part('partials/content', 'hero');?>
  <?php get_queried_object()?>
  <section class="contact contact-page">
    <div class="container">
      <div class="row">
        <div class="col-12 col-lg-6">
          <div class="contact-box">
            <h3 class="contact-box__title">
              <?php echo get_field('contact_page_title')?>
            </h3>
            <p class="contact-box__main-text">
              <?php echo get_field('contact_page_text');?>
            </p>
            <div class="d-flex flex-wrap contact-box__text-box">
              <img  src="<?php echo get_template_directory_uri()?>/img/icon.png" alt="" class="contact-box__pic">
              <div class="">
                <p class="contact-box__text contact-box__text--pin">
                  ADRES
                </p>
                <p class="contact-box__text contact-box__text--bold">
                  <?php echo get_option('adress')?>
                </p>
                <p class="contact-box__text contact-box__text--pink mt-4">
                  Godziny otwarcia:
                </p>
                <p class="contact-box__text contact-box__text--bold">
                  poniedziałek:
                </p>
                <p class="contact-box__text">
                  <?php echo get_option('monday_hours')?>
                </p>
                <p class="contact-box__text contact-box__text--bold">
                  wtorek - piątek:
                </p>
                <p class="contact-box__text">
                  <?php echo get_option('week_hours')?>
                </p>
                <p class="contact-box__text contact-box__text--bold">
                  sobotu - niedziele i święta:
                </p>
                <p class="contact-box__text">
                  <?php echo get_option('weekend_hours')?>
                </p>
              </div>
            </div>
            <div class="d-flex flex-wrap contact-box__text-box">
              <img  src="<?php echo get_template_directory_uri()?>/img/icon2.png" alt="" class="contact-box__pic">
              <div class="">
                <p class="contact-box__text contact-box__text--pink">
                  TELEFON:
                </p>
                <p class="contact-box__text">
                  <?php echo get_option('phone_number') ?>
                </p>
              </div>
            </div>
            <div class="d-flex flex-wrap contact-box__text-box">
              <img src="<?php echo get_template_directory_uri()?>/img/icon3.png" alt="" class="contact-box__pic">
              <div class="">
                <p class="contact-box__text contact-box__text--pink">
                  E-MAIL:
                </p>
                <p class="contact-box__text">
                  <?php echo get_option('email') ?>
                </p>
                <div class="contact-box__info mt-5">
                <p class="contact-box__text ">
                    <span class="contact-box__text--pink contact-box__text--bold">
                      NIP:
                    </span>
                    <?php echo get_option('nip') ?>
                  </p>
                  <p class="contact-box__text ">
                    <span class="contact-box__text--pink contact-box__text--bold">
                      REGON:
                    </span>
                    <?php echo get_option('regon') ?>
                  </p>
                  <p class="contact-box__text ">
                    <span class="contact-box__text--pink contact-box__text--bold">
                      KRS:
                    </span>
                    <?php echo get_option('krs') ?>
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-12 col-lg-6">

          <div class="contact__form">
          <svg class="contact-page__pic" xmlns="http://www.w3.org/2000/svg" width="224.555"
              height="14.338" viewBox="0 0 224.555 14.338">
              <path id="Path_39" data-name="Path 39"
                d="M-51.743-208.481c12.473,0,12.473,11.338,24.945,11.338s12.473-11.338,24.947-11.338S10.623-197.143,23.1-197.143s12.475-11.338,24.95-11.338S60.523-197.143,73-197.143s12.476-11.338,24.951-11.338,12.476,11.338,24.952,11.338,12.478-11.338,24.955-11.338,12.478,11.338,24.956,11.338"
                transform="translate(51.743 209.981)" fill="none" stroke="#f52a85"
                stroke-miterlimit="10" stroke-width="3" />
            </svg>
            <h2 class="contact__title basic-title">
              <?php if(!empty(get_field('contact_title'))) {echo get_field('contact_title');} else {echo 'Skontaktuj się z nami';} ;?>
            </h2>
            <?php if(!empty(get_field('contact_form'))){echo do_shortcode(get_field('contact_text'));} else {echo do_shortcode('[contact-form-7 id="42" title="Contact form 1"]');} ;?>
          </div>
        </div>
      </div>
    </div>
  </section>
<section class="map">
  <?php $location = get_field('map')?>
<div class="acf-map" data-zoom="16">
        <div class="marker" data-lat="<?php echo esc_attr($location['lat']); ?>" data-lng="<?php echo esc_attr($location['lng']); ?>"></div>
    </div>
</section>
</main>

<?php
get_footer();