<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Nenufar
 */

?>

<footer class="footer" style="background-image: url('<?php echo get_template_directory_uri()?>/img/footer-bg.png');">
  <div class="container">
    <div class="row">
      <div class="col-12 col-md-6 col-xl-4">
      <img src="<?php echo get_site_icon_url()?>" alt="" class="footer__logo">
      </div>
    </div>
    <div class="row">
      <div class="col-12 col-md-6 col-xl-4">
        <h2 class="footer__text footer__text--bold">
        <?php echo get_option('name') ?>
        </h2>
        <a href="tel:<?php echo remove_spaces(get_option('phone_number'))?>" class="footer__text footer__text--yellow">
          tel. <?php echo get_option('phone_number') ?>
        </a>
        <a href="mailto:<?php echo get_option('email') ?>" class="footer__text ">
          <?php echo get_option('email') ?>
        </a>
        <a href="" class="footer__text">
          <?php echo get_option('adress') ?>
        </a>
      </div>
      <div class="col-12 col-md-6 col-xl-2">
        <p class="footer__text">
          NIP: <?php echo get_option('nip') ?>
        </p>
        <p class="footer__text">
          REGON <?php echo get_option('regon') ?>
        </p>
        <p class="footer__text">
          KRS <?php echo get_option('krs') ?>
        </p>
      </div>
      <div class="col-12 col-md-6 col-xl-2 offset-xl-1">
        <h3 class="footer__title">
          MENU
        </h3>
        <ul class="footer__nav">
                <?php
                  global $post;
                  $page_slug = $post->post_name;
                  $menuLocations = get_nav_menu_locations();
                  $menuID = $menuLocations['menu-1'];
                  $primaryNav = wp_get_nav_menu_items($menuID);
                  $submenu = false;
                  $start = false;
                  $html = '';
                  foreach ($primaryNav as $navItem) {
                    $navItemSlug = sanitize_title($navItem->title);
                    $activeClass = '';
                    if($page_slug == $navItemSlug) {
                      $activeClass = 'active';
                    }
                  if ($navItem->menu_item_parent == 0) {
                    if ($submenu == true) {
                      $html .= '</ul></div>';
                      $submenu = false;
                    }
                    if($start == true) {
                      $html .= '</li>';
                    }
                    $html .= '<li class="footer__item"><a class = "'.$activeClass.'" href="' . $navItem->url . '" title="' . $navItem->title . '">' .$navItem->title. '</a>';
                  }
                  else if ($submenu == false) {
                    $html .= '<div class="special-submenu"><ul class ="footer__submenu">';
                    $html .= '<li class="footer__subitem"><a class = "'.$activeClass.'"  href="' . $navItem->url . '" title="' . $navItem->title . '">' . $navItem->title . '</a></li>';
                    $submenu = true;
                  }
                  else {
                    $html .= '<li class="footer__subitem"><a class = "'.$activeClass.'"  href="' . $navItem->url . '" title="' . $navItem->title . '">' . $navItem->title . '</a></li>';
									}
									$start = true;
                  }
                  echo $html;
                  ?>
        </ul>

      </div>
      <div class="col-12 col-md-6 col-xl-3">
        <h3 class="footer__title">
          OBSERWUJ NAS
        </h3>
        <div class="footer__social-box">
          <a href="<?php echo get_option('facebook')?>" class="footer__social-media">
            <img src="<?php echo get_template_directory_uri()?>/img/facebook.svg" alt="facebook" class="footer__pic">
          </a>
          <a href="<?php echo get_option('twitter')?>" class="footer__social-media">
            <img src="<?php echo get_template_directory_uri()?>/img/twitter.svg" alt="twitter" class="footer__pic">
          </a>
          <a href="<?php echo get_option('youtube')?>" class="footer__social-media">
            <img src="<?php echo get_template_directory_uri()?>/img/youtube.svg" alt="YouTube" class="footer__pic">
          </a>
        </div>

      </div>
    </div>
  </div>
</footer>

<?php wp_footer(); ?>

<!-- Messenger Wtyczka czatu Code -->
    <div id="fb-root"></div>

    <!-- Your Wtyczka czatu code -->
    <div id="fb-customer-chat" class="fb-customerchat">
    </div>

    <script>
      var chatbox = document.getElementById('fb-customer-chat');
      chatbox.setAttribute("page_id", "159695924132737");
      chatbox.setAttribute("attribution", "biz_inbox");
    </script>

    <!-- Your SDK code -->
    <script>
      window.fbAsyncInit = function() {
        FB.init({
          xfbml            : true,
          version          : 'v15.0'
        });
      };

      (function(d, s, id) {
        var js, fjs = d.getElementsByTagName(s)[0];
        if (d.getElementById(id)) return;
        js = d.createElement(s); js.id = id;
        js.src = 'https://connect.facebook.net/pl_PL/sdk/xfbml.customerchat.js';
        fjs.parentNode.insertBefore(js, fjs);
      }(document, 'script', 'facebook-jssdk'));
    </script>

</body>

</html>