<?php
/**
 * Template Name:  Front page
 * Front page
 */

get_header();
$hero_bg = get_field('hero-bg-image');
$text_color = get_field('hero_bg_color');
$bg_color = get_field('hero_bg_color');
?>
<style>
.hero__link {
  background-color: <?php echo $text_color?>;
  border-color: <?php echo $text_color?>
}

.hero__link:hover {
  background-color: #ffffff;
  color: <?php echo $text_color?>;
}

.hero__link:nth-child(2) {
  color: <?php echo $text_color?>;
  border-color: <?php echo $text_color?>
}

.hero__link:nth-child(2):hover {
  color: #ffffff;
  background-color: <?php echo $text_color?>;
}
</style>
<main>
  <?php get_template_part('partials/content', 'hero');?>

  <section class="attractions" style="background-image:url(<?php echo get_template_directory_uri()?>/img/home-bg.svg);">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <h3 class="attractions__overtitle">
            <?php echo get_field('atraction_top_text') ?>
          </h3>
          <h2 class="attractions__title basic-title">
            <?php echo get_field('attraction_title')?>
          </h2>
          <p class="attractions__text">
            <?php echo get_field('attraction_text')?>
          </p>
        </div>
      </div>
      <div class="row">
        <div class="col-12">
          <div class="d-flex justify-content-between flex-wrap">
            <!-- posts -->
            <?php
            $query_args = array(
            'post_type' => array('attraction'),
            'posts_per_page' => '10',
            'meta_key'		=> 'not_show_in_archive',
            'meta_value'	=> 0,
            );
            $query = new WP_Query( $query_args );
            if ($query->have_posts()): while ($query->have_posts()) : $query->the_post();
            $the_ID = get_the_ID();
            $post_name = get_field('short_title', $the_ID);
            $post_pic = get_field('home_page_picture', $the_ID);
            $post_short_text = get_field('short_text', $the_ID);
            $post_link = get_permalink();
            $post_color = get_field('hero_bg_color', $the_ID);
            $featured = get_field('featured', $the_ID);
            ?>
            <div class="attraction-single <?php if($featured) { echo 'featured'; }?>">
              <a href="<?php echo $post_link ?>" class="attraction-single__link relative"
                style="color:<?php echo $post_color;?>; border-color:<?php echo $post_color;?>;">
                <img src="<?php echo $post_pic;?>" alt="" class="attraction-single__photo">
                <div class="attraction-single__text-box">
                  <h3 class="attraction-single__title" style="color:<?php echo $post_color?>">
                    <?php echo $post_name ?>

                  </h3>
                  <p class="attraction-single__subtitle">
                    <?php echo get_field('subtitle')?>
                  </p>
                  <p class="attraction-single__text">
                    <?php echo $post_short_text ?>
                  </p>
                </div>
                <img src="<?php echo get_template_directory_uri()?>/img/right-arrow.svg" alt=""
                  style="background-color:<?php echo $post_color?>;" class="attraction-single__arrow">
              </a>
            </div>
            <?php endwhile; endif; wp_reset_postdata(); ?>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="banner">
    <div class="container">
      <?php if (get_field('banner')):?>
      <div class="row">
        <div class="col-12">
          <img src="<?php echo get_field('banner')?>" alt="" class="gallery__banner">
        </div>
      </div>
      <?php endif?>
    </div>
  </section>
  <?php get_template_part('partials/content', 'gallery');?>

  <section class="numbers">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <d class="d-flex justify-content-between flex-wrap">
            <div class="numbers__item relative">
              <img src="<?php echo get_template_directory_uri()?>/img/number1.svg" alt="" class="numbers__bg">
              <div class="numbers__box">
                <p class="numbers__number count">
                  <?php echo get_field('number_1');?>
                </p>
                <h3 class="numbers__title">
                  <?php echo get_field('number_text_1')?>
                </h3>
              </div>
            </div>
            <div class="numbers__item relative">
              <img src="<?php echo get_template_directory_uri()?>/img/number2.svg" alt="" class="numbers__bg">
              <div class="numbers__box">
                <p class="numbers__number count">
                  <?php echo get_field('number_2');?>
                </p>
                <h3 class="numbers__title">
                  <?php echo get_field('number_text_2')?>
                </h3>
              </div>
            </div>
            <div class="numbers__item relative">
              <img src="<?php echo get_template_directory_uri()?>/img/number3.svg" alt="" class="numbers__bg">
              <div class="numbers__box">
                <p class="numbers__number count">
                  <?php echo get_field('number_3');?>
                </p>
                <h3 class="numbers__title">
                  <?php echo get_field('number_text_3')?>
                </h3>
              </div>
            </div>
            <div class="numbers__item relative">
              <img src="<?php echo get_template_directory_uri()?>/img/number4.svg" alt="" class="numbers__bg">
              <div class="numbers__box">
                <p class="numbers__number count">
                  <?php echo get_field('number_4');?>
                </p>
                <h3 class="numbers__title">
                  <?php echo get_field('number_text_4')?>
                </h3>
              </div>
            </div>
          </d>

        </div>
      </div>
    </div>
  </section>

  <section class="offer" style="background-image:url(<?php echo get_template_directory_uri()?>/img/offer-bg.png);">
    <div class="container">
      <div class="row">
        <div class="col-12 col-lg-7">
          <div class="relative">
            <svg class="offer__image" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
              xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 638 673.3"
              style="enable-background:new 0 0 638 673.3;" xml:space="preserve">
              <path
                fill="<?php if(empty(get_field('archive_photo_bg_color'))){ echo '#ffcf14';} else {echo get_field('archive_photo_bg_color');}?>"
                id="_81" class="st0"
                d="M370.4,673.3h-64.9c-2.3-0.4-4.6-0.7-6.9-0.9c-12.8-0.4-25.6-0.5-38.4-1c-28.5-1.1-55.3-8.8-79.2-24.4
	  c-20.4-13.3-40.1-28-59.5-42.8c-39.3-30.1-69.1-68-90.3-112.6C5.5,437.2-4.3,380.1,1.7,320.2c3.5-36.1,14.9-70.9,33.3-102.1
	  c12.8-21.8,29-41,45-60.4c27.2-32.9,57.7-62.1,94-84.9c41.4-26,86.4-40,135.1-42.5c20.4-1,40.5,1.9,60.1,7.7c4.6,1.4,8.8,4.5,13.4,5
	c21.4,2.3,42.5,5.9,62.9,12.8c48.3,16.2,88.4,45,122.8,81.9c26.1,28,42.7,61.1,52.7,97.9c9.8,36.1,11.9,73.1,12.8,110.2
	c0.6,23.8,0.6,47.6-0.1,71.4c-0.5,15.1-1.5,30.3-4.4,45.1c-11.5,57.4-40.1,105.2-83.1,144.5c-3.1,2.8-6.5,5.4-9.7,8.1l0.9,1.1
	c5.7-4.5,12.2-8.2,16.9-13.6c14-16.2,27.9-32.6,40.5-49.9c14.8-20.3,26.5-42.7,36.4-65.8c1.3-3,2.5-6.1,6.9-4.1v2
	c-1.8,6.2-3.5,12.5-5.4,18.7c-9.7,30.7-28,56.4-47.2,81.7c-20.2,26.7-45.7,45.7-77.7,55.8c-22.5,7.1-45,14.3-67.8,20.5
	c-14.7,4-29.9,6.5-44.9,9.2C386.9,671.9,378.6,672.4,370.4,673.3z M360.7,41.3c-53.5-8-103.6,3.7-152,25.7
	C258.3,52,308.8,42.7,360.7,41.3z M405.8,1.4c0.8,1.5,1.4,3.4,2.7,4.2c29,17.8,58.1,35.4,87.3,53c1.2,0.7,2.9,0.4,4.4,0.5
	c-0.5-1.4-0.6-3.1-1.6-4.1C474.3,30.4,446,12.2,412.9,1.5c-1.6-0.5-3.2-0.9-5.1-1.5C407.1,0.4,406.4,0.9,405.8,1.4L405.8,1.4z" />
            </svg>
            <svg class="offer__photo" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
              xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 638 673.3"
              style="enable-background:new 0 0 638 673.3;" xml:space="preserve">
              <defs>
                <pattern id="bgImage" patternUnits="userSpaceOnUse" width="100%" height="100%">
                  <image href="<?php echo get_field('offer_photo')?>" x="0" y="0" width="100%" height="100%" />
                </pattern>
              </defs>
              <path fill="url(#bgImage)" id="_81" class="st0"
                d="M370.4,673.3h-64.9c-2.3-0.4-4.6-0.7-6.9-0.9c-12.8-0.4-25.6-0.5-38.4-1c-28.5-1.1-55.3-8.8-79.2-24.4
	c-20.4-13.3-40.1-28-59.5-42.8c-39.3-30.1-69.1-68-90.3-112.6C5.5,437.2-4.3,380.1,1.7,320.2c3.5-36.1,14.9-70.9,33.3-102.1
	c12.8-21.8,29-41,45-60.4c27.2-32.9,57.7-62.1,94-84.9c41.4-26,86.4-40,135.1-42.5c20.4-1,40.5,1.9,60.1,7.7c4.6,1.4,8.8,4.5,13.4,5
	c21.4,2.3,42.5,5.9,62.9,12.8c48.3,16.2,88.4,45,122.8,81.9c26.1,28,42.7,61.1,52.7,97.9c9.8,36.1,11.9,73.1,12.8,110.2
	c0.6,23.8,0.6,47.6-0.1,71.4c-0.5,15.1-1.5,30.3-4.4,45.1c-11.5,57.4-40.1,105.2-83.1,144.5c-3.1,2.8-6.5,5.4-9.7,8.1l0.9,1.1
	c5.7-4.5,12.2-8.2,16.9-13.6c14-16.2,27.9-32.6,40.5-49.9c14.8-20.3,26.5-42.7,36.4-65.8c1.3-3,2.5-6.1,6.9-4.1v2
	c-1.8,6.2-3.5,12.5-5.4,18.7c-9.7,30.7-28,56.4-47.2,81.7c-20.2,26.7-45.7,45.7-77.7,55.8c-22.5,7.1-45,14.3-67.8,20.5
	c-14.7,4-29.9,6.5-44.9,9.2C386.9,671.9,378.6,672.4,370.4,673.3z M360.7,41.3c-53.5-8-103.6,3.7-152,25.7
	C258.3,52,308.8,42.7,360.7,41.3z M405.8,1.4c0.8,1.5,1.4,3.4,2.7,4.2c29,17.8,58.1,35.4,87.3,53c1.2,0.7,2.9,0.4,4.4,0.5
	c-0.5-1.4-0.6-3.1-1.6-4.1C474.3,30.4,446,12.2,412.9,1.5c-1.6-0.5-3.2-0.9-5.1-1.5C407.1,0.4,406.4,0.9,405.8,1.4L405.8,1.4z" />
            </svg>
          </div>

        </div>
        <div class="col-12 col-lg-5">
          <h2 class="offer__title basic-title">
            <?php echo get_field('offer_title');?>
          </h2>
          <p class="offer__text">
            <?php echo get_field('offer_text');?>
          </p>

          <a href="tel:<?php echo remove_spaces(get_field('offer_phone'))?>>" class="offer__link">
            <img src="<?php echo get_template_directory_uri()?>/img/offer-icon.png" alt="" class="offer__icon">
            <p class="offer__text offer__text--link">
              <?php  echo get_field('offer_phone_text');?>
              <span class="offer__phone d-block">
                <?php  echo get_field('offer_phone');?>
              </span>
            </p>

          </a>
          <a href="<?php  echo get_field('offer_link');?>" class="offer__button">
            <?php  echo get_field('offer_link_text');?> <img
              src="<?php echo get_template_directory_uri()?>/img/chevron.svg" alt="" class="offer__pic">
          </a>
        </div>
      </div>
    </div>
  </section>

  <section class="news">
    <div class="container">
      <?php if (wp_count_posts()->publish > 0) :?>
      <div class="row">
        <div class="col-12">
          <img src="<?php echo get_template_directory_uri()?>/img/pink-decoration.png" alt=""
            class="d-block mx-auto info__pic">
          <h2 class="news__title basic-title">
            <?php echo get_field('news_title')?>
          </h2>
          <p class="news__subtitle">
            <?php echo get_field('news_text')?>
          </p>
        </div>
      </div>
      <div class="row">
        <?php
            $query_args = array(
            'post_type' => array('post'),
            'posts_per_page' => '6',
            );
            $query = new WP_Query( $query_args );
            if ($query->have_posts()): while ($query->have_posts()) : $query->the_post();
            $the_ID = get_the_ID();
            $name = get_the_title();
            $pic = get_the_post_thumbnail_url( $the_ID , array( 540, 220) );
            $short_text = get_field('short-text', $the_ID);
            $link = get_permalink();
            ?>
        <div class="col-12 col-md-6">
          <div class="news-single">
            <img src="<?php echo $pic?>" alt="<?php echo $name?>" class="news-single__image">
            <h3 class="news-single__title">
              <?php echo $name?>

            </h3>
            <p class="news-single__text">
              <?php echo $short_text ?>
            </p>

            <a href="<?php echo $link ?>" class="news-single__link">
              Czytaj więcej
            </a>
          </div>
        </div>
        <?php
              endwhile;
              endif;
              wp_reset_postdata()
              ?>

        <div class="col-12">
          <a href="<?php echo get_home_url()?>/aktualnosci/" class="news__link">
            Starsze wpisy <img src="<?php echo get_template_directory_uri()?>/img/chevron.svg" alt="" class="news__pic">
          </a>
        </div>
      </div>
      <?php endif?>
      <div class="row mt-5">
        <div class="col-12 col-md-6">
          <div class="news-button">
            <img src="<?php echo get_template_directory_uri()?>/img/ticket.png" alt="" class="news-button__image">
            <a href="<?php echo get_field('news_link_1')?>" class="news-button__link">
              <?php echo get_field('news_text_link_1')?>
            </a>
          </div>
        </div>
        <div class="col-12 col-md-6">
          <div class="news-button">
            <img src="<?php echo get_template_directory_uri()?>/img/shedule.png" alt="" class="news-button__image">
            <a href="<?php echo get_field('news_link_2')?>" class="news-button__link news-button__link--yellow">
              <?php echo get_field('news_text_link_2')?>
            </a>
          </div>
        </div>
      </div>
    </div>
  </section>



  <?php get_template_part('partials/content', 'contact');?>
  <?php get_template_part('partials/content', 'info');?>
</main>

<?php
get_footer();