<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Nenufar
 */

?>
<!doctype html>
<html>

<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Alegreya+Sans:wght@300;400;500;700;800;900&family=Baloo+Thambi+2:wght@400;500;600;700;800&family=Barlow:wght@300;400;500;600;700;800;900&family=Fredoka+One&family=Open+Sans:wght@300;400;600;700;800&display=swap" rel="stylesheet"> 
  <?php wp_head(); ?>
	
	<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src='https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);})(window,document,'script','dataLayer','GTM-NBRWVC4');</script>
<!-- End Google Tag Manager -->
</head>

<body>
	
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-NBRWVC4" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
  
	<header>
    <section class="header-top">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <button class="header-top__button mobile-button d-xl-none">
              <img src="<?php echo get_template_directory_uri()?>/img/bars.svg" alt="" class="header-top__bars">
            </button>
            <div class="d-none d-lg-flex header-top__main flex-wrap justify-content-md-between">
              <div>
                <a href="tel:<?php echo remove_spaces(get_option('phone_number'))?>" class="header-top__contact">
                  <img src="<?php echo get_template_directory_uri()?>/img/smartphone.svg" alt="" class="header-top__pic">
                  <?php echo get_option('phone_number') ?>
                </a>
                <a href="mailto:<?php echo get_option('email')?>" class="header-top__contact">
                  <img src="<?php echo get_template_directory_uri()?>/img/mail.svg" alt="" class="header-top__pic">
                  <?php echo get_option('email') ?>
                </a>
              </div>
              <div>
                <a href="" class="header-top__contact">
                  <img src="<?php echo get_template_directory_uri()?>/img/clock.svg" alt="" class="header-top__pic">
                  Godziny otwarcia
                </a>
                <a href="" class="header-top__contact">
                  <img src="<?php echo get_template_directory_uri()?>/img/info.svg" alt="" class="header-top__pic">
                  Rezerwacje
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="header-main">
      <div class="container">
        <div class="row">

          <div class="col-12 d-none d-lg-block">
            <nav class="header-main__nav">
              <ul>
                <?php
                  global $post;
                  $i = 0;
                  $icon_url = get_template_directory_uri() . '/img/logo.svg';
                  $page_slug = $post->post_name;
                  $menuLocations = get_nav_menu_locations();
                  $menuID = $menuLocations['menu-1'];
                  $primaryNav = wp_get_nav_menu_items($menuID);
                  $submenu = false;
                  $start = false;
                  $html = '';
                  foreach ($primaryNav as $navItem) {
                    $navItemSlug = sanitize_title($navItem->title);
                    $activeClass = '';
                    if($page_slug == $navItemSlug) {
                      $activeClass = 'active';
                    }
                  if ($navItem->menu_item_parent == 0) {
                    if ($submenu == true) {
                      $html .= '</ul></div>';
                      $submenu = false;
                    }
                    if($start == true) {
                      $html .= '</li>';
                    }
                    $html .= '<li class="header-main__item"><a class = "'.$activeClass.'" href="' . $navItem->url . '" title="' . $navItem->title . '">' .$navItem->title. '</a>';
                    $i = $i + 1;
                    if ($i == 3) {
                      $html .= '<li class="header-main__item header-main__logo"><a class="p-0" href="'.get_home_url().'"><img src="'.$icon_url.'" alt="" class=""></a></li>';
                    }
                  }
                  else if ($submenu == false) {
                    $html .= '<div class="special-submenu"><ul class ="header-main__submenu">';
                    $html .= '<li class="header-main__subitem"><a class = "'.$activeClass.'"  href="' . $navItem->url . '" title="' . $navItem->title . '">' . $navItem->title . '</a></li>';
                    $submenu = true;
                  }
                  else {
                    $html .= '<li class="header-main__subitem"><a class = "'.$activeClass.'"  href="' . $navItem->url . '" title="' . $navItem->title . '">' . $navItem->title . '</a></li>';
									}
									$start = true;
                  }
                  echo $html;
                  ?>
              </ul>

            </nav>

            <a href="<?php echo get_home_url()?>/kup-bilet" class="header-main__button">
              KUP BILET
                </a>
          </div>
          <div class="col-12 d-lg-none">
            <div class="header-mobile ">
              <div class="container">
                <div class="row">
                  <div class="col-12">
                    <div class="header-mobile__row">
                      <img src="<?php echo get_template_directory_uri() ?>/img/logo.svg" alt="logo"
                        class='header-mobile__logo bg-white'>
                      <button class="d-xl-none header__button mobile-button mobile-button--absolute">
                        <img src="<?php echo get_template_directory_uri() ?>/img/close.svg" alt="">
                      </button>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-12">
                    <ul class="header-mobile__menu">
                      <?php
                $menuLocations = get_nav_menu_locations();
                $menuID = $menuLocations['menu-1'];
                $primaryNav = wp_get_nav_menu_items($menuID);
                $submenu = false;
                $start = false;
                $htmlMobile = '';
                foreach ($primaryNav as $navItem) {
                  if ($navItem->menu_item_parent == 0) {
                    if ($submenu == true) {
                      $htmlMobile .= '</ul>';
                      $submenu = false;
                    }
                    if($start == true) {
                      $htmlMobile  .= '</li>';
                    }
                    $htmlMobile  .= '<li class="header-mobile__item"><a href="' . $navItem->url . '" title="' . $navItem->title . '">' . $navItem->title . '</a>';
                  } 
                  else if ($submenu == false) {
                    $htmlMobile  .= '<ul class ="header-mobile__submenu">';
                    $htmlMobile  .= '<li class="header-mobile__subitem"><a href="' . $navItem->url . '" title="' . $navItem->title . '">' . $navItem->title . '</a></li>';
                    $submenu = true;
                  } 
                  else {
                    $htmlMobile  .= '<li class="header-mobile__subitem"><a href="' . $navItem->url . '" title="' . $navItem->title . '">'.$navItem->title.'</a></li>';
                  }
                  $start = true;
                }
                echo $htmlMobile ;
                ?>
                    </ul>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>


  </header>