<?php
/**
 * Custom functions that act independently of the theme templates.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package understrap
 */


/*------------------------------------*\
	Custom Post Types
\*------------------------------------*/

register_post_type('attraction', // Register Custom Post Type
    array(
    'labels' => array(
        'name' => __('Atrakcje', 'attraction'), // Rename these to suit
        'singular_name' => __('Atrakcja', 'attraction'),
        'add_new' => __('Dodaj nową', 'attraction'),
        'add_new_item' => __('Dodaj nową', 'attraction'),
        'edit' => __('Edytuj', 'attraction'),
        'edit_item' => __('Edytuj', 'attraction'),
        'new_item' => __('Nowy', 'attraction'),
        'view' => __('Pokaż', 'attraction'),
        'view_item' => __('Pokaż', 'attraction'),
        'search_items' => __('Szukaj', 'attraction'),
        'not_found' => __('Nie znaleziono', 'attraction'),
        'not_found_in_trash' => __('Nie znaleziono w koszu', 'attraction')
    ),
    //'taxonomies' => array( 'category' ),
    'capability_type' => 'post',
    'public' => true,
    'hierarchical' => true, //false allows for order post plugin
    'has_archive' => true,
    'publicly_queryable'  => true,
    'supports' => array(
        'title',
        'editor',
        'thumbnail'
    ), // Go to Dashboard Custom HTML5 Blank post for supports
    'can_export' => true, // Allows export in Tools > Export
    'rewrite' => array('slug' => 'atrakcje'),
));
register_post_type('prices', // Register Custom Post Type
    array(
    'labels' => array(
        'name' => __('Ceny', 'prices'), // Rename these to suit
        'singular_name' => __('Cena', 'prices'),
        'add_new' => __('Dodaj nową', 'prices'),
        'add_new_item' => __('Dodaj nową', 'prices'),
        'edit' => __('Edytuj', 'prices'),
        'edit_item' => __('Edytuj', 'prices'),
        'new_item' => __('Nowy', 'prices'),
        'view' => __('Pokaż', 'prices'),
        'view_item' => __('Pokaż', 'prices'),
        'search_items' => __('Szukaj', 'prices'),
        'not_found' => __('Nie znaleziono', 'prices'),
        'not_found_in_trash' => __('Nie znaleziono w koszu', 'prices')
    ),
    //'taxonomies' => array( 'category' ),
    'capability_type' => 'post',
    'public' => true,
    'hierarchical' => true, //false allows for order post plugin
    'has_archive' => false,
    'publicly_queryable'  => true,
    'supports' => array(
        'title',
    ), // Go to Dashboard Custom HTML5 Blank post for supports
    'can_export' => true, // Allows export in Tools > Export
));

