<?php 

add_action( 'admin_menu', 'info_options_page' );

function info_options_page() {

	add_options_page(
		'Informations', // page <title>Title</title>
		'Informations', // menu link text
		'manage_options', // capability to access the page
		'info-slug', // page URL slug
		'info_page_content', // callback function with content
		2 // priority
	);

}
add_image_size('archive', 630, 644);

function info_page_content(){

	echo '<div class="wrap">
	<h1>Informations</h1>
	<form method="post" action="options.php">';
			
		settings_fields( 'info_settings' ); // settings group name
		do_settings_sections( 'info-slug' ); // just a page slug
		submit_button();

	echo '</form></div>';

}

add_action( 'admin_init',  'info_register_setting' );

function info_register_setting(){

	register_setting(
		'info_settings', // settings group name
		'phone_number', // option name
		'sanitize_text_field' // sanitization function
	);
	register_setting(
		'info_settings', // settings group name
		'email', // option name
		'sanitize_text_field' // sanitization function
	);
  register_setting(
		'info_settings', // settings group name
		'monday_hours', // option name
		'sanitize_text_field' // sanitization function
	);
  register_setting(
		'info_settings', // settings group name
		'week_hours', // option name
		'sanitize_text_field' // sanitization function
	);
  register_setting(
		'info_settings', // settings group name
		'weekend_hours', // option name
		'sanitize_text_field' // sanitization function
	);
	register_setting(
		'info_settings', // settings group name
		'facebook', // option name
		'sanitize_text_field' // sanitization function
	);
	register_setting(
		'info_settings', // settings group name
		'twitter', // option name
		'sanitize_text_field' // sanitization function
	);
	register_setting(
		'info_settings', // settings group name
		'adress', // option name
		'sanitize_text_field' // sanitization function
	);
	register_setting(
		'info_settings', // settings group name
		'youtube', // option name
		'sanitize_text_field' // sanitization function
	);
	register_setting(
		'info_settings', // settings group name
		'nip', // option name
		'sanitize_text_field' // sanitization function
	);
	register_setting(
		'info_settings', // settings group name
		'regon', // option name
		'sanitize_text_field' // sanitization function
	);
	register_setting(
		'info_settings', // settings group name
		'krs', // option name
		'sanitize_text_field' // sanitization function
	);
	register_setting(
		'info_settings', // settings group name
		'name', // option name
		'sanitize_text_field' // sanitization function
	);
	add_settings_section(
		'main_info_section', // section ID
		'Basic info', // title (if needed)
		'', // callback function (if needed)
		'info-slug' // page slug
	);

	add_settings_section(
		'hours_info_section', // section ID
		'Open hours', // title (if needed)
		'', // callback function (if needed)
		'info-slug' // page slug
	);
	add_settings_section(
		'social_media_info_section', // section ID
		'Social media', // title (if needed)
		'', // callback function (if needed)
		'info-slug' // page slug
	);
	add_settings_section(
		'business_info_section', // section ID
		'Business', // title (if needed)
		'', // callback function (if needed)
		'info-slug' // page slug
	);
	add_settings_field(
		'phone_number',
		'Phone Number',
		'phone_text_field_html', // function which prints the field
		'info-slug', // page slug
		'main_info_section', // section ID
		array( 
			'label_for' => 'phone-number',
			'class' => 'phone-number', // for <tr> element
		)
	);
  add_settings_field(
		'email',
		'Email',
		'email_text_field_html', // function which prints the field
		'info-slug', // page slug
		'main_info_section', // section ID
		array( 
			'label_for' => 'email',
			'class' => 'email', // for <tr> element
		)
	);
	add_settings_field(
		'adress',
		'Adress',
		'adress_text_field_html', // function which prints the field
		'info-slug', // page slug
		'main_info_section', // section ID
		array( 
			'label_for' => 'adress',
			'class' => 'adress', // for <tr> element
		)
	);
  add_settings_field(
		'monday_hours',
		'Monday',
		'monday_hours_text_field_html', // function which prints the field
		'info-slug', // page slug
		'hours_info_section', // section ID
		array( 
			'label_for' => 'm-hours',
			'class' => 'm-hours', // for <tr> element
		)
	);
  add_settings_field(
		'week_hours',
		'Thuesday - Friday',
		'week_hours_text_field_html', // function which prints the field
		'info-slug', // page slug
		'hours_info_section', // section ID
		array( 
			'label_for' => 'w-hours',
			'class' => 'w-hours', // for <tr> element
		)
	);
  add_settings_field(
		'weekend_hours',
		'Weekend',
		'weekend_hours_text_field_html', // function which prints the field
		'info-slug', // page slug
		'hours_info_section', // section ID
		array( 
			'label_for' => 'end-hours',
			'class' => 'end-hours', // for <tr> element
		)
	);
	add_settings_field(
		'facebook',
		'Facebook',
		'facebook_text_field_html', // function which prints the field
		'info-slug', // page slug
		'social_media_info_section', // section ID
		array( 
			'label_for' => 'facebook',
			'class' => 'facebook', // for <tr> element
		)
	);
	add_settings_field(
		'twitter',
		'Twitter',
		'twitter_text_field_html', // function which prints the field
		'info-slug', // page slug
		'social_media_info_section', // section ID
		array( 
			'label_for' => 'twitter',
			'class' => 'twitter', // for <tr> element
		)
	);
	add_settings_field(
		'youtube',
		'YouTube',
		'youtube_text_field_html', // function which prints the field
		'info-slug', // page slug
		'social_media_info_section', // section ID
		array( 
			'label_for' => 'youtube',
			'class' => 'youtube', // for <tr> element
		)
	);
	add_settings_field(
		'nip',
		'NIP',
		'nip_text_field_html', // function which prints the field
		'info-slug', // page slug
		'business_info_section', // section ID
		array( 
			'label_for' => 'nip',
			'class' => 'nip', // for <tr> element
		)
	);
	add_settings_field(
		'regon',
		'REGON',
		'regon_text_field_html', // function which prints the field
		'info-slug', // page slug
		'business_info_section', // section ID
		array( 
			'label_for' => 'regon',
			'class' => 'regon', // for <tr> element
		)
	);
	add_settings_field(
		'krs',
		'KRS',
		'krs_text_field_html', // function which prints the field
		'info-slug', // page slug
		'business_info_section', // section ID
		array( 
			'label_for' => 'krs',
			'class' => 'krs', // for <tr> element
		)
	);
	add_settings_field(
		'name',
		'Full company name',
		'name_text_field_html', // function which prints the field
		'info-slug', // page slug
		'business_info_section', // section ID
		array( 
			'label_for' => 'name',
			'class' => 'bame', // for <tr> element
		)
	);
}
function name_text_field_html(){

	$text = get_option( 'name' );

	printf(
		'<input type="text" id="name" name="name" value="%s" placeholder="" />',
		esc_attr( $text )
	);
}

function phone_text_field_html(){

	$text = get_option( 'phone_number' );

	printf(
		'<input type="text" id="phone_number" name="phone_number" value="%s" placeholder="" />',
		esc_attr( $text )
	);
}
function email_text_field_html(){

	$text = get_option( 'email' );

	printf(
		'<input type="text" id="email" name="email" value="%s" />',
		esc_attr( $text )
	);
}
function adress_text_field_html(){

	$text = get_option( 'adress' );

	printf(
		'<input type="text" id="adress" name="adress" value="%s" placeholder="" />',
		esc_attr( $text )
	);
}
function monday_hours_text_field_html(){

	$text = get_option( 'monday_hours' );

	printf(
		'<input type="text" id="monday_hours" name="monday_hours" value="%s" />',
		esc_attr( $text )
	);
}
function week_hours_text_field_html(){

	$text = get_option( 'week_hours' );

	printf(
		'<input type="text" id="week_hours" name="week_hours" value="%s" />',
		esc_attr( $text )
	);
}
function weekend_hours_text_field_html(){

	$text = get_option( 'weekend_hours' );

	printf(
		'<input type="text" id="weekend_hours" name="weekend_hours" value="%s" />',
		esc_attr( $text )
	);
}
function facebook_text_field_html(){

	$text = get_option( 'facebook' );

	printf(
		'<input type="text" id="facebook" name="facebook" value="%s" />',
		esc_attr( $text )
	);
}
function twitter_text_field_html(){

	$text = get_option( 'twitter' );
	
	printf(
		'<input type="text" id="twitter" name="twitter" value="%s" />',
		esc_attr( $text )
	);
	}
function youtube_text_field_html(){

		$text = get_option( 'youtube' );
		
		printf(
			'<input type="text" id="youtube" name="youtube" value="%s" />',
			esc_attr( $text )
		);
}
function nip_text_field_html(){

	$text = get_option( 'nip' );
	
	printf(
		'<input type="text" id="nip" name="nip" value="%s" />',
		esc_attr( $text )
	);
}
function regon_text_field_html(){

		$text = get_option( 'regon' );
		
		printf(
			'<input type="text" id="regon" name="regon" value="%s" />',
			esc_attr( $text )
	);
}
function krs_text_field_html(){

	$text = get_option( 'krs' );
	
	printf(
		'<input type="text" id="krs" name="krs" value="%s" />',
		esc_attr( $text )
	);
	}
function remove_spaces($string) {
  $new_string = str_replace(' ', '', $string);
  return $new_string;
}