<?php
/**
 * Template Name:  group
 * full group
 */

get_header();
?>
<main>

  <?php
$hero_bg = get_field('hero-bg-image');
$text_color = get_field('hero_bg_color');
$bg_color = get_field('hero_bg_color');
?>
  <style>
  .hero__link {
    background-color: <?php echo $text_color?>;
    border-color: <?php echo $text_color?>
  }

  .hero__link:hover {
    background-color: #ffffff;
    color: <?php echo $text_color?>;
  }

  .hero__link:nth-child(2) {
    color: <?php echo $text_color?>;
    border-color: <?php echo $text_color?>
  }

  .hero__link:nth-child(2):hover {
    color: #ffffff;
    background-color: <?php echo $text_color?>;
  }
  </style>

  <?php get_template_part('partials/content', 'hero');?>
  <section class="single-attraction-main">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <img src="<?php echo get_the_post_thumbnail_url()?>" alt="" class="single-attraction-main__logo">
          <svg class="single-attraction-main__pic" xmlns="http://www.w3.org/2000/svg" width="224.555" height="14.338"
            viewBox="0 0 224.555 14.338">
            <path id="Path_39" data-name="Path 39"
              d="M-51.743-208.481c12.473,0,12.473,11.338,24.945,11.338s12.473-11.338,24.947-11.338S10.623-197.143,23.1-197.143s12.475-11.338,24.95-11.338S60.523-197.143,73-197.143s12.476-11.338,24.951-11.338,12.476,11.338,24.952,11.338,12.478-11.338,24.955-11.338,12.478,11.338,24.956,11.338"
              transform="translate(51.743 209.981)" fill="none" stroke="<?php echo $text_color?>" stroke-miterlimit="10"
              stroke-width="3" />
          </svg>
          <h2 class="single-attraction-main__title">
            <?php echo get_the_title()?>
          </h2>
          <div class="single-attraction-main__text">
            <?php echo the_content()?>
          </div>
        </div>
      </div>
    </div>
  </section>
  <?php if(!empty(get_field('attractions_group'))):?>
  <section class="group-attractions"
    style="background-image:url(<?php echo get_template_directory_uri()?>/img/page-bg2.svg);">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <div class="d-flex flex-wrap justify-content-between">
            <?php 
            $attractionCounter =0;
            foreach (get_field('attractions_group') as $attraction):?>
            <?php $the_ID = $attraction['attraction'];
            $attractionCounter = $attractionCounter + 1;
            $post_name = get_field('short_title', $the_ID);
            $post_pic = get_field('home_page_picture', $the_ID);
            $post_short_text = get_field('short_text', $the_ID);
            $post_link = get_permalink($the_ID);
            $post_color = get_field('hero_bg_color', $the_ID);
            $featured = $attraction['featured'];
            $post_pic = get_field('group_section_picture', $the_ID);
            ?>
            <div class="group-attractions__item">
              <button type="button" class="group-attractions__link relative w-100 bg-white attraction-modal-link"
                data-toggle="modal" data-target="#attractionModal-<?php echo $attractionCounter?>"
                style="color:<?php echo $post_color;?>; border-color:<?php echo $post_color;?>;">
                <img src="<?php echo $post_pic;?>" alt="" class="group-attractions__photo">
                <div class="group-attractions__text-box">
                  <h3 class="group-attractions__title" style="color:<?php echo $post_color?>">
                    <?php echo $post_name ?>
                  </h3>
                  <p class="group-attractions__text">
                    <?php echo $post_short_text ?>
                  </p>
                </div>
                <img src="<?php echo get_template_directory_uri()?>/img/right-arrow.svg" alt=""
                  style="background-color:<?php echo $post_color?>;" class="group-attractions__arrow">
              </button>
            </div>
            <?php endforeach; wp_reset_postdata();  ?>
          </div>
        </div>
      </div>
    </div>
  </section>
  <?php endif;?>
  <?php get_template_part('partials/content', 'contact');?>
  <?php get_template_part('partials/content', 'info');?>
</main>
<!-- Modal -->

<?php 
            $attractionCounter =0;
            foreach (get_field('attractions_group') as $attraction):?>
<?php $the_ID = $attraction['attraction'];
            $attractionCounter = $attractionCounter + 1;
            $post_name = get_field('short_title', $the_ID);
            $post_pic = get_field('home_page_picture', $the_ID);
            $post_short_text = get_field('short_text', $the_ID);
            $post_link = get_permalink($the_ID);
            $post_color = get_field('hero_bg_color', $the_ID);
            $featured = $attraction['featured'];
            $post_pic = get_field('group_section_picture', $the_ID);
            ?>
<style>
<?php echo '#attractionModal-'.$attractionCounter.' h3,
#attractionModal-'.$attractionCounter.' li::marker {
  color: '.$post_color.';
}'?>
</style>
<div class="attraction-modal modal" id="attractionModal-<?php echo $attractionCounter?>" tabindex="-1" role="dialog"
  aria-labelledby="attractionModalBody-<?php echo $attractionCounter?>" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <button type="button " class="close attraction-modal-link"
        data-target="#attractionModal-<?php echo $attractionCounter?>" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button>
      <div class="modal-body">
        <h3><?php echo $post_name?></h3>
        <?php echo get_field('goup_section_info', $the_ID)?>
        <p>
        Nie zwlekaj i zarezerwuj pobyt już teraz


        <a class="d-block" href="tel:<?php echo remove_spaces(get_option('phone_number'))?>">
          <?php echo get_option('phone_number') ?></a>
        <a class="d-block" href="mailto:park@nenufarclub.pl"> <?php echo get_option('email') ?>l</a>

      </p>
      </div>

    </div>
  </div>
</div>
<?php endforeach; wp_reset_postdata();  ?>
<?php

get_footer();