<?php
/**
 * Template Name:  prices
 * prices
 */

get_header();
$hero_bg = get_field('hero-bg-image');

$text_color = get_field('hero_bg_color');
$bg_color = get_field('hero_bg_color');
?>

<style>
<?php $counter_price=0;
$query_args=array('post_type'=> array('prices'),
  'posts_per_page'=> '1000',
  'meta_key'=> 'not_show',
  'meta_value'=> 0,
);
$query=new WP_Query($query_args);
if ($query->have_posts()): while ($query->have_posts()) : $query->the_post();
$the_ID=get_the_ID();
$price_color=get_field('color', $the_ID);
$counter_price=$counter_price+1;
echo '.price-section--'.$counter_price.' .vertical-prices .tribe-amount, .price-section--'.$counter_price.' .vertical-prices .tribe-currency-symbol, .price-section--'.$counter_price.' .tribe-amount, .price-section--'.$counter_price.' .tribe-currency-symbol { color: '.$price_color.';} .price-section--'.$counter_price.' .tribe-common-c-btn {background-color: '.$price_color.' !important;}';
endwhile;
endif;
wp_reset_postdata();

?>.hero__link {
  background-color: <?php echo $text_color?>;
  border-color: <?php echo $text_color?>
}

.hero__link:hover {
  background-color: #ffffff;
  color: <?php echo $text_color?>;
}

.hero__link:nth-child(2) {
  color: <?php echo $text_color?>;
  border-color: <?php echo $text_color?>;
  background: white;
}

.hero__link:nth-child(2):hover {
  color: #ffffff;
  background-color: <?php echo $text_color?>;
}
.vertical-prices .tribe-tickets__tickets-item {
  flex-direction: row !important;
}
.vertical-prices .tribe-tickets__tickets-item-content-title {
  max-width: 200px !important;
margin-right: 24px !important;
font-weight: bold !important;
margin-bottom: 30px !important;
text-align: left !important;
min-width: 200px !important;
}
.vertical-prices .d-flex {
  flex-direction: column;
}
.vertical-prices .tribe-tickets__tickets-item {
  margin: 24px 0 0 0 !important;
  width: auto !important;
}
</style>
<main>
  <?php get_template_part('partials/content', 'hero');?>

  <section class="prices">
    <div class="container mb-5">
      <?php
        $counter_price = 0;
            $query_args = array(
            'post_type' => array('prices'),
            'posts_per_page' => '-1',
            'meta_key'		=> 'not_show',
            'meta_value'	=> 0,
            );
            $query = new WP_Query( $query_args );
            if ($query->have_posts()): while ($query->have_posts()) : $query->the_post();
            $the_ID = get_the_ID();
            $post_title = get_the_title();
            $post_short_name = get_field('additional_title', $the_ID);
            $post_short_text = get_field('additional_text', $the_ID);
            $price_color  = get_field('color', $the_ID);
            $prices_attraction = get_field('prices_attractions', $the_ID);
            $additional_prices = get_field('additional_prices', $the_ID);
            $top_text = get_field('top_text', $the_ID);
            if(empty($prices_attraction)){
              $prices_array = array(1);
            }
            else {
              $prices_array = $prices_attraction;
            }
            $counter_price = $counter_price + 1;
            ?>
      <div class="row">
        <div class="col-12">

          <svg class="prices__pic" xmlns="http://www.w3.org/2000/svg" width="224.555" height="14.338"
            viewBox="0 0 224.555 14.338">
            <path id="Path_39" data-name="Path 39"
              d="M-51.743-208.481c12.473,0,12.473,11.338,24.945,11.338s12.473-11.338,24.947-11.338S10.623-197.143,23.1-197.143s12.475-11.338,24.95-11.338S60.523-197.143,73-197.143s12.476-11.338,24.951-11.338,12.476,11.338,24.952,11.338,12.478-11.338,24.955-11.338,12.478,11.338,24.956,11.338"
              transform="translate(51.743 209.981)" fill="none" stroke="<?php echo $price_color?>"
              stroke-miterlimit="10" stroke-width="3" />
          </svg>

          <h2 class="prices__title">

            <?php echo $post_title?>
          </h2>
        </div>
      </div>
      <?php if(count($prices_array) < 2):?>
      <div class="row">
        <div class="col-12">
          <div class="d-flex">
            <?php 
            $thumbnail = '';
            foreach  (get_field('prices_attractions', $the_ID) as $attraction) {
              $thumbnail =  wp_get_attachment_url( get_post_thumbnail_id($attraction['attraction'] ), 'thumbnail' ); 
            }
          ?>
            <?php if (!empty($thumbnail)):?>
            <img src="<?php echo $thumbnail?>" alt="" class="prices__image">
            <?php endif?>
            <div class="prices-section price-section--<?php echo $counter_price?>">
              <?php if(!empty($top_text)):?>
              <h3 class="prices-section__title" style="color: <?php echo $price_color?>">
                <?php echo $top_text?>
              </h3>
              <?php endif?>
              <div class="d-flex">
                <?php echo do_shortcode('[tribe_tickets post_id="'.$the_ID.'"]');?>
                <?php if(!empty(get_field('free_entrance'))):?>
                <div class="prices-section__box">
                  <p class="prices-section__text prices-section__text--gray">
                  </p>
                  <p class="prices-section__text">
                    <?php echo get_field('free_entrance')?>
                  </p>
                  <div class="prices-section__price prices-section__price--small"
                    style="color: <?php echo $price_color?>;">
                    Wstęp wolny
                  </div>
                </div>
                <?php endif?>
              </div>
            </div>
            <?php if(!empty($additional_prices)):?>
            <div class="prices-section prices-section price-section--<?php echo $counter_price?>">
              <?php if(!empty(get_field('top_text', $additional_prices))):?>
              <h3 class="prices-section__title" style="color: <?php echo $price_color?>">
                <?php echo get_field('top_text', $additional_prices)?>
              </h3>
              <?php endif?>
              <div class="d-flex">
                <?php echo do_shortcode('[tribe_tickets post_id="'.$additional_prices.'"]');?>
              </div>
            </div>
            <?php endif ?>
          </div>

        </div>
      </div>
      <?php else: ?>
      <div class="row">
        <div class="col-12">
          <div class="d-flex">
            <?php foreach ($prices_attraction as $attraction):?>
            <?php $post_id = $attraction['attraction']; 
              $thumbnail =  wp_get_attachment_url( get_post_thumbnail_id($post_id ), 'thumbnail' ); ?>
            <img src="<?php echo $thumbnail?>" alt="" class="prices__image">
            <?php endforeach?>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="prices-section price-section--<?php echo $counter_price?>">
          <?php if(!empty($top_text)):?>
          <h3 class="prices-section__title" style="color: <?php echo $price_color?>">
            <?php echo $top_text?>
          </h3>
          <?php endif?>
          <div class="d-flex">
            <?php echo do_shortcode('[tribe_tickets post_id="'.$the_ID.'"]');?>
            <?php if(!empty(get_field('free_entrance'))):?>
            <div class="prices-section__box">
              <p class="prices-section__text prices-section__text--gray">
              </p>
              <p class="prices-section__text">
                <?php echo get_field('free_entrance')?>
              </p>
              <div class="prices-section__price prices-section__price--small" style="color: <?php echo $price_color?>;">
                Wstęp wolny
              </div>
            </div>
            <?php endif?>
          </div>
        </div>
        <div class="prices-section price-section--<?php echo $counter_price?>">
          <?php if(!empty(get_field('top_text', $additional_prices))):?>
          <h3 class="prices-section__title" style="color: <?php echo $price_color?>">
            <?php echo get_field('top_text', $additional_prices)?>
          </h3>
          <?php endif?>
          <div class="d-flex">
            <?php echo do_shortcode('[tribe_tickets post_id="'.$additional_prices.'"]');?>
          </div>
        </div>
      </div>
      <?php endif?>

      <div class="row">
        <div class="col-12">
          <p class="prices__text prices__text--bold prices__text prices__text--center">
            <?php echo $post_short_name?>
          </p>
          <p class="prices__text">
            <?php echo $post_short_text?>
          </p>
        </div>
      </div>
      <?php if(!empty(get_field('additional_prices_bottom'))):?>
      <div class="row">
        <div class="col-12 price-section--<?php echo $counter_price?>">
          <div class="vertical-prices">
            <?php echo do_shortcode('[tribe_tickets post_id="'.get_field('additional_prices_bottom').'"]');?>
          </div>

        </div>
      </div>
      <?php endif?>
      <?php endwhile; endif; wp_reset_postdata(); ?>
    </div>
  </section>

  <?php get_template_part('partials/content', 'contact');?>


  <?php get_template_part('partials/content', 'info');?>
</main>

<?php
get_footer();