<?php
get_header();
$hero_bg = get_field('hero-bg-image');

$text_color = get_field('hero_bg_color');
$bg_color = get_field('hero_bg_color');

?>
<style>
.hero__link {
  background-color: <?php echo $text_color?>;
  border-color: <?php echo $text_color?>
}

.hero__link:hover {
  background-color: #ffffff;
  color: <?php echo $text_color?>;
}

.hero__link:nth-child(2) {
  color: <?php echo $text_color?>;
  border-color: <?php echo $text_color?>;
  background: white;
}

.hero__link:nth-child(2):hover {
  color: #ffffff;
  background-color: <?php echo $text_color?>;
}

li::marker {
  color: <?php echo $text_color?>;
}
</style>
<main>
  <?php get_template_part('partials/content', 'hero');?>
  <section class="single-attraction-main">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <img src="<?php echo get_the_post_thumbnail_url()?>" alt="" class="single-attraction-main__logo">
          <svg class="single-attraction-main__pic" xmlns="http://www.w3.org/2000/svg" width="224.555" height="14.338"
            viewBox="0 0 224.555 14.338">
            <path id="Path_39" data-name="Path 39"
              d="M-51.743-208.481c12.473,0,12.473,11.338,24.945,11.338s12.473-11.338,24.947-11.338S10.623-197.143,23.1-197.143s12.475-11.338,24.95-11.338S60.523-197.143,73-197.143s12.476-11.338,24.951-11.338,12.476,11.338,24.952,11.338,12.478-11.338,24.955-11.338,12.478,11.338,24.956,11.338"
              transform="translate(51.743 209.981)" fill="none" stroke="<?php echo $text_color?>" stroke-miterlimit="10"
              stroke-width="3" />
          </svg>
          <h2 class="single-attraction-main__title">
            <?php echo get_the_title()?>
          </h2>
          <div class="single-attraction-main__text">
            <?php echo the_content()?>
          </div>
        </div>
      </div>
    </div>
  </section>
  <?php if (!empty(get_field('attraction_text_list'))):?>
  <section class="single-attraction-list-section">
    <div class="container">
      <?php foreach(get_field('attraction_text_list') as $list_section):?>
      <div class="row">
        <div class="col-12">
          <svg class="single-attraction-list-section__pic" xmlns="http://www.w3.org/2000/svg" width="224.555"
            height="14.338" viewBox="0 0 224.555 14.338">
            <path id="Path_39" data-name="Path 39"
              d="M-51.743-208.481c12.473,0,12.473,11.338,24.945,11.338s12.473-11.338,24.947-11.338S10.623-197.143,23.1-197.143s12.475-11.338,24.95-11.338S60.523-197.143,73-197.143s12.476-11.338,24.951-11.338,12.476,11.338,24.952,11.338,12.478-11.338,24.955-11.338,12.478,11.338,24.956,11.338"
              transform="translate(51.743 209.981)" fill="none" stroke="<?php echo $text_color?>" stroke-miterlimit="10"
              stroke-width="3" />
          </svg>
          <h3 class="single-attraction-list-section__main-title">
            <?php echo $list_section['title']?>
          </h3>
          <p class="single-attraction-list-section__main-text">
            <?php echo $list_section['text']?>
          </p>
        </div>
      </div>
      <div class="row">
        <div class="col-12">
          <ul class="single-attraction-list-section__main">
            <?php foreach($list_section['list'] as $text_list_item):?>
            <?php $width = ''; 
              if($list_section['full_width']) 
              {
                $width = 'single-attraction-list-section__item--full-width';
                }
              ?>
            <li class="single-attraction-list-section__item <?php echo $width?>">
              <h3 class="single-attraction-list-section__title">
                <?php echo $text_list_item['title']?>
              </h3>
              <p class="single-attraction-list-section__text">
                <?php echo $text_list_item['text']?>
              </p>
            </li>
            <?php endforeach?>
          </ul>
        </div>
        <?php if(!empty($list_section['additional_text_left']) || !empty($list_section['additional_text_right'])):?>
        <div class="col-12">
          <div class="single-attraction-list-section__box">
            <p class="single-attraction-list-section__additional-text">
              <?php echo $list_section['additional_text_left']?>
            </p>
            <p class="single-attraction-list-section__additional-text" style="color: <?php echo $text_color?>;">
              <?php echo $list_section['additional_text_right']?>
            </p>
          </div>
        </div>
        <?php endif?>
      </div>
      <?php endforeach?>
    </div>

  </section>
  <?php endif?>

  <?php if (!empty(get_field('single_attraction_text_section'))):?>
  <section class="single-attraction-text-section">
    <div class="container">

      <?php $sectionCounter = 0; ?>
      <?php foreach(get_field('single_attraction_text_section') as $text_section):?>
      <div class="row">
        <?php  $class1 = '';
                $class2 = '';
                $padding = "pe-lg-5";
                if($sectionCounter % 2 == 1) {
                  $class1 = 'order-lg-first';
                  $class2 = 'order-lg-last';
                  $padding = "ps-lg-5";
                }
                $sectionCounter = $sectionCounter  + 1;
                ?>
        <div class="col-12 col-lg-6 <?php echo $class2?>">
          <div class="single-attraction-text-section__text-box <?php echo $padding ?>">
            <svg class="single-attraction-text-section__pic" xmlns="http://www.w3.org/2000/svg" width="224.555"
              height="14.338" viewBox="0 0 224.555 14.338">
              <path id="Path_39" data-name="Path 39"
                d="M-51.743-208.481c12.473,0,12.473,11.338,24.945,11.338s12.473-11.338,24.947-11.338S10.623-197.143,23.1-197.143s12.475-11.338,24.95-11.338S60.523-197.143,73-197.143s12.476-11.338,24.951-11.338,12.476,11.338,24.952,11.338,12.478-11.338,24.955-11.338,12.478,11.338,24.956,11.338"
                transform="translate(51.743 209.981)" fill="none" stroke="<?php echo $text_color?>"
                stroke-miterlimit="10" stroke-width="3" />
            </svg>
            <?php if(!empty($text_section['title'])):?>
            <h3 class="single-attraction-text-section__title">
              <?php echo $text_section['title']?>
            </h3>
            <?php endif?>
            <div class="single-attraction-text-section__text">
              <?php echo nl2br($text_section['text'])?>
            </div>
          </div>

        </div>
        <div class="col-12 col-lg-6  <?php echo $class1?>">
          <svg class="single-attraction-text-section__photo" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 552.12 605.91">
          <pattern id="sectionImage-<?php echo $sectionCounter?>" patternUnits="userSpaceOnUse" width="100%" height="100%">
              <image href="<?php echo $text_section['photo'];?>" x="0" y="0" width="100%"
                height="100%" preserveAspectRatio="xMinYMin slice"></image>
            </pattern>
            <path fill="url(#sectionImage-<?php echo $sectionCounter?>)" xmlns="http://www.w3.org/2000/svg" id="ramka_na_zdjecie_1" data-name="ramka na zdjecie 1"
              class="cls-1"
              d="M217.79,1.83C461.49-22.34,552.12,197.6,552.12,382.25S282.56,668.48,106.35,563.75,16.41,350.26,59,241.5-25.91,26,217.79,1.83Z" />
          </svg>
        </div>
      </div>
      <?php endforeach?>
    </div>

  </section>
  <?php endif?>
  <?php if(!empty(get_field('attraction_carousel'))):?>
  <section class="attractions-carousel">
    <div class="container">
      <div class="row">
        <div class="row">
          <div class="col-12">
          <svg class="mx-auto d-block single-attraction-text-section__pic" xmlns="http://www.w3.org/2000/svg" width="224.555"
              height="14.338" viewBox="0 0 224.555 14.338">
              <path id="Path_39" data-name="Path 39"
                d="M-51.743-208.481c12.473,0,12.473,11.338,24.945,11.338s12.473-11.338,24.947-11.338S10.623-197.143,23.1-197.143s12.475-11.338,24.95-11.338S60.523-197.143,73-197.143s12.476-11.338,24.951-11.338,12.476,11.338,24.952,11.338,12.478-11.338,24.955-11.338,12.478,11.338,24.956,11.338"
                transform="translate(51.743 209.981)" fill="none" stroke="<?php echo $text_color?>"
                stroke-miterlimit="10" stroke-width="3" />
            </svg>
            <h2 class="basic-title mb-5 attrations-carousel__main-title">
              <?php echo get_field('attractions_carousel_title')?>
            </h2>
          </div>
        </div>
        <div class="col-12">
          <div class="attractions-carousel__main">
            <?php foreach (get_field('attraction_carousel') as $carousel_item):?>
            <div>
              <div class="attractions-carousel__item">
                <img src="<?php echo $carousel_item['image']?>" alt="" class="attractions-carousel__image">
                <h3 class="attractions-carousel__title">
                  <?php echo $carousel_item['title']?>
                </h3>
                <p class="attractions-carousel__text">
                  <?php echo $carousel_item['text']?>
                </p>
              </div>
            </div>

            <?php endforeach?>
          </div>
        </div>
      </div>
    </div>
  </section>
  <?php endif?>
  <?php if (!empty(get_field('single_attraction_section_title')) || !empty(get_field('single_attraction_section_text_before_wave_pic')) || !empty(get_field('single_attraction_section_text_after_wave_pic')) || !empty(get_field('single_attraction_section_leftt_photo')) || !empty(get_field('single_attraction_section_right_photo'))):?>
  <section class="single-attraction-section">
    <div class="container">
      <div class="row">
        <div class="col-12 col-lg-6">
          <p class="single-attraction-section__top-text" style="color:<?php echo $text_color?>;">
            <?php echo get_field('single_attraction_section_top_text')?>
          </p>
          <h3 class="single-attraction-section__title">
            <?php echo get_field('single_attraction_section_title')?>
          </h3>
          <ul class="single-attraction-section__list">
            <?php  foreach(get_field('single_attraction_section_list') as $list_item):?>
            <li class="single-attraction-section__list-item">
              <?php echo $list_item['text']?>
            </li>
            <?php endforeach?>
          </ul>
        </div>
        <div class="col-12 col-lg-6">
          <?php if(!empty(get_field('single_attraction_section_right_photo'))):?>
          <svg class="single-attraction-section__photo" xmlns="http://www.w3.org/2000/svg" style="max-width: 100%;"
            viewBox="0  0 650 600" width="100%" height="100%">
            <pattern id="bgImage1" patternUnits="userSpaceOnUse" width="100%" height="100%">
              <image href="<?php echo get_field('single_attraction_section_right_photo')?>" x="0" y="0" width="100%"
                height="100%" preserveAspectRatio="xMinYMin slice"></image>
            </pattern>
            <path xmlns="http://www.w3.org/2000/svg" id="_4" data-name=" 4" class="cls-1"
              d="M440.65,63.22C351.43,18.15,177.55-55.6,53.9,68.41s4.17,392.26,4.17,392.26,120.42,237.2,378.44,73.95,174.36-301,174.36-301S529.86,108.28,440.65,63.22Z"
              fill="url(#bgImage1)" />
          </svg>
          <?php endif?>
        </div>
      </div>
      <div class="row">
        <div class="col-12 col-lg-6">
          <?php if(!empty(get_field('single_attraction_section_leftt_photo'))):?>
          <svg class="single-attraction-section__photo" xmlns="http://www.w3.org/2000/svg" style="max-width: 100%;"
            viewBox="0  0 650 600" width="100%" height="100%">
            <pattern id="bgImage2" patternUnits="userSpaceOnUse" width="100%" height="100%">
              <image href="<?php echo get_field('single_attraction_section_leftt_photo')?>" x="0" y="0" width="100%"
                height="100%" preserveAspectRatio="xMinYMin slice"></image>
            </pattern>
            <path xmlns="http://www.w3.org/2000/svg" id="_4" data-name=" 4" class="cls-1"
              d="M440.65,63.22C351.43,18.15,177.55-55.6,53.9,68.41s4.17,392.26,4.17,392.26,120.42,237.2,378.44,73.95,174.36-301,174.36-301S529.86,108.28,440.65,63.22Z"
              fill="url(#bgImage2)" />
          </svg>
          <?php endif?>
        </div>
        <?php if(!empty(get_field('single_attraction_section_text_before_wave_pic')) || !empty(get_field('single_attraction_section_text_after_wave_pic'))):?>
        <div class="col-12 col-lg-6">
          <div class="single-attraction-section__text-box">
            <p class="single-attraction-section__text">
              <?php echo nl2br(get_field('single_attraction_section_text_before_wave_pic'))?>
            </p>

            <svg class="single-attraction-section__pic" xmlns="http://www.w3.org/2000/svg" width="224.555"
              height="14.338" viewBox="0 0 224.555 14.338">
              <path id="Path_39" data-name="Path 39"
                d="M-51.743-208.481c12.473,0,12.473,11.338,24.945,11.338s12.473-11.338,24.947-11.338S10.623-197.143,23.1-197.143s12.475-11.338,24.95-11.338S60.523-197.143,73-197.143s12.476-11.338,24.951-11.338,12.476,11.338,24.952,11.338,12.478-11.338,24.955-11.338,12.478,11.338,24.956,11.338"
                transform="translate(51.743 209.981)" fill="none" stroke="<?php echo $text_color?>"
                stroke-miterlimit="10" stroke-width="3" />
            </svg>
            <p class="single-attraction-section__text">
              <?php echo nl2br(get_field('single_attraction_section_text_after_wave_pic'))?>
            </p>
          </div>

        </div>
        <?php endif?>
      </div>
    </div>
  </section>
  <?php endif?>
  <?php if(!empty(get_field('gallery'))):?>
  <?php get_template_part('partials/content', 'gallery');?>
  <?php endif?>
  <?php if(!empty(get_field('contact_form'))):?>
  <?php get_template_part('partials/content', 'contact');?>
  <?php endif?>
  <?php get_template_part('partials/content', 'info');?>

</main>

<?php
get_footer();