<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Nenufar
 */

get_header();
?>


<?php get_template_part('partials/content', 'hero');?>
  <section class="single-post">
    <div class="container">
      <div class="row">
        <div class="col-12 col-lg-5">
          <img src="<?php echo get_the_post_thumbnail_url()?>" alt="" class="single-post__logo">
          <svg class="single-post__pic" xmlns="http://www.w3.org/2000/svg" width="224.555" height="14.338"
            viewBox="0 0 224.555 14.338">
            <path id="Path_39" data-name="Path 39"
              d="M-51.743-208.481c12.473,0,12.473,11.338,24.945,11.338s12.473-11.338,24.947-11.338S10.623-197.143,23.1-197.143s12.475-11.338,24.95-11.338S60.523-197.143,73-197.143s12.476-11.338,24.951-11.338,12.476,11.338,24.952,11.338,12.478-11.338,24.955-11.338,12.478,11.338,24.956,11.338"
              transform="translate(51.743 209.981)" fill="none" stroke="<?php echo $text_color?>" stroke-miterlimit="10"
              stroke-width="3" />
          </svg>
        </div>
        <div class="col-12 col-lg-6 offset-lg-1">
          <h2 class="single-post__title text-left">
            <?php echo get_the_title()?>
          </h2>
          <div class="single-post__text">
            <p>
              <?php echo get_field('short_text');?>
            </p>

          </div>
        </div>
      </div>
    </div>
  </section>
  <section class="single-content mb-5">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <?php echo the_content()?>
        </div>
      </div>
    </div>
  </section>

<?php
get_footer();